function stitch_elm()
%%
folders=dir('*');

folders=folders([folders.isdir]);
folders={folders.name};
folders=folders(~contains(folders,'.'));

maxproj_folder=fullfile(pwd,"hyb_maxproj");
mkdir(maxproj_folder);
%%
% maxprojection
slice_list=[];
%%
for nn=1:numel(folders)
    %%
    fov_list=dir(fullfile(folders{nn},'*'));
    fov_list={fov_list.name};
    fov_list=fov_list(~contains(fov_list,{'.','maxproj'}));
    posx=zeros(numel(fov_list),1);
    posy=posx;
    slicenum=posx;
    %%
    for mm=1:numel(fov_list)
        imfiles=dir(fullfile(folders{nn},fov_list{mm},'*.tif'));
        imfiles={imfiles.name};
        % extract positions
        ch=zeros(numel(imfiles),1);
        pos=ch;
        t=ch;
        z=ch;
        finfo=imfinfo(fullfile(folders{nn},fov_list{mm},imfiles{1}));
        im=zeros(finfo.Height, finfo.Width,numel(imfiles));
        for qq=1:numel(imfiles)
            im(:,:,qq)=imread(fullfile(folders{nn},fov_list{mm},imfiles{qq}));
            data=textscan(imfiles{qq},'img_channel%u_position%u_time%u_z%u.tif');
            ch(qq)=data{1};
            pos(qq)=data{2};
            t(qq)=data{3};
            z(qq)=data{4};
        end
        % max proj for each channel
        uniq_t=unique(t);
        uniq_ch=unique(ch);
        max_im=zeros(size(im,1),size(im,2),numel(uniq_ch)*numel(uniq_t),'uint16');
        qqq=1;
        for pp=1:numel(uniq_t)
            for qq=1:numel(uniq_ch)
                max_im(:,:,qqq)=max(im(:,:,ch==uniq_ch(qq)&t==uniq_t(pp)),[],3);
                qqq=qqq+1;
            end
        end
        % rotate 180 to fit our convention.
        max_im=imrotate(max_im, 180);
        % save
        posinfo=textscan(fov_list{mm},'%u-Pos%u_%u');
        slicenum(mm)=posinfo{1};
        while 1
            if ismember(slicenum(mm),slice_list)
                slicenum(mm)=100+slicenum(mm);
            else
                break
            end
        end
        if ~isempty(posinfo{1}) % If there are tiles
            %parse Pos

            posx(mm)=posinfo{2};
            posy(mm)=posinfo{3};
            maxproj_filename="MAX_Pos"+slicenum(mm)+"_"+sprintf('%.3u',posx(mm))+ ...
                "_"+sprintf('%.3u',posy(mm));
        else % single FOV
            %slice_list{slice_counter,2}=1;
            maxproj_filename=folders{nn}+"_"+fov_list{mm};
        end

        if size(max_im,3)==1
            imwrite(max_im(:,:,1),fullfile(maxproj_folder, maxproj_filename+"_1.tif"));
        elseif size(max_im,3)>1
            for qq=1:size(max_im,3)
                imwrite(max_im(:,:,qq),fullfile(maxproj_folder, maxproj_filename+"_"+qq+".tif"));
            end
        end

    end
    slice_list=[slice_list;unique(slicenum)];
end



%%

%% stitch with MIST
%basewd=cd(maxproj_folder);
fprintf('Parsing filenames ...\n')
files=dir(fullfile(maxproj_folder,'MAX*.tif'));
files={files.name};
sipxyc=cell(length(files),4);
for i=1:numel(files)
    sipxyc(i,:)=textscan(files{i},'%*s %s %u %u %u %*s',1,'Delimiter',{'_','.'});
end

xy=cell2mat(sipxyc(:,2:3));
c=cell2mat(sipxyc(:,4));
pos=cellfun(@cell2mat,sipxyc(:,1),'UniformOutput',false);
uniqpos=sort_nat(unique(pos));


check_fiji_install()

% set up worker pools
numcores=feature('numcores');
[~,mem]=memory;
maxcore=min(round(numcores*1.5), floor(mem.PhysicalMemory.Total/4000000000));
p=gcp('nocreate');
if isempty(p)
    parpool("local",maxcore);
elseif p.NumWorkers<maxcore
    parpool("local",maxcore);
end
fprintf('Runing MIST to stitch reference channels ...\n');
Miji(true);

% shared inputs to MIST
% find fiji path
fiji_path=fileparts(fileparts(which('miji')));
planpath=fullfile(fiji_path,'lib','fftw','fftPlans');
fftwlibraypath=fullfile(fiji_path,'lib','fftw');
if contains(planpath,' ')
    planpath=['[',planpath,']'];
end
if contains(fftwlibraypath,' ')
    fftwlibraypath=['[',fftwlibraypath,']'];
end

headless='false';
numcores = feature('numcores');
grid_direction='UR'; %000_000 starts from upper right corner.
overlap=0.1;
uniq_c=unique(c);
for i=1:length(uniqpos)
    for m=1:numel(uniq_c)
        %% position specific inputs to MIST
        disp(uniqpos{i})
        in_pos=ismember(pos,uniqpos{i});
        grid_x=max(xy(in_pos,1))+1;
        grid_y=max(xy(in_pos,2))+1;


        file_name="MAX_"+uniqpos{i}+"_{ccc}_{rrr}_"+uniq_c(m)+".tif";
        output_prefix="MAX_"+uniqpos{i}+"ch"+uniq_c(m);
        output_path=fullfile(maxproj_folder,'stitching');
        img_path=maxproj_folder;

        %fix paths
        if contains(file_name,' ')
            file_name=['[',file_name,']'];
        end
        if contains(output_prefix,' ')
            output_prefix=['[',output_prefix,']'];
        end
        if contains(output_path,' ')
            output_path=['[',output_path,']'];
        end
        if contains(img_path,' ')
            img_path=['[',img_path,']'];
        end
        %%

        %assemble MIST inputs
        MIJ.run('MIST', ...
            "gridwidth="+num2str(grid_x)+ ...
            ' gridheight='+num2str(grid_y)+ ...
            ' starttilerow=0'+ ...
            ' starttilecol=0'+ ...
            ' imagedir='+img_path+ ...%may need double \\
            ' filenamepattern='+file_name+ ...
            ' filenamepatterntype=ROWCOL'+ ...
            ' gridorigin='+grid_direction+ ...
            ' assemblefrommetadata=false'+ ...
            ' assemblenooverlap=false'+ ...
            ' globalpositionsfile=[]'+ ...
            ' numberingpattern=HORIZONTALCOMBING'+ ...
            ' startrow=0'+ ...
            ' startcol=0'+ ...
            ' extentwidth='+num2str(grid_x)+ ...
            ' extentheight='+num2str(grid_y)+ ...
            ' timeslices=0'+ ...
            ' istimeslicesenabled=false'+ ...
            ' outputpath='+output_path+ ...
            ' displaystitching=false'+ ...
            ' outputfullimage=true'+ ...
            ' outputmeta=true'+ ...
            ' outputimgpyramid=false'+ ...
            ' blendingmode=AVERAGE'+ ...
            ' blendingalpha=0.5'+ ...
            ' compressionmode=UNCOMPRESSED'+ ...
            ' outfileprefix='+output_prefix+ ...
            ' unit=MICROMETER'+ ...
            ' unitx=0.33'+ ...
            ' unity=0.33'+ ...
            ' programtype=AUTO'+ ...
            ' numcputhreads='+num2str(numcores)+ ...
            ' loadfftwplan=true'+ ...
            ' savefftwplan=true'+ ...
            ' fftwplantype=MEASURE'+ ...
            ' fftwlibraryname=libfftw3'+ ...
            ' fftwlibraryfilename=libfftw3.dll'+ ...
            ' planpath='+planpath+ ...%may need to tweak this in the future
            ' fftwlibrarypath='+fftwlibraypath+ ...%may need to tweak this in the future
            ' stagerepeatability=0'+ ...
            ' horizontaloverlap='+num2str(overlap*100,'%.1f')+ ...
            ' verticaloverlap='+num2str(overlap*100,'%.1f')+ ...
            ' numfftpeaks=10'+ ...
            ' overlapuncertainty=NaN'+ ...
            ' isusedoubleprecision=true'+ ...
            ' isusebioformats=false'+ ...
            ' issuppressmodelwarningdialog=false'+ ...
            ' isenablecudaexceptions=false'+ ...
            ' translationrefinementmethod=EXHAUSTIVE'+ ...
            ' numtranslationrefinementstartpoints=32'+ ...
            ' headless='+headless+ ...
            ' loglevel=MANDATORY'+ ...
            ' debuglevel=NONE');
    end
end
% cleanup
MIJ.exit;

%% convert to jpg
white_point=99.99; % in percentile
black_point=0.5; % in percentile

stitch_dir=fullfile(maxproj_folder,'stitching');
stitched_files=dir(fullfile(stitch_dir,'*.tif'));
stitched_files={stitched_files.name};




for nn=1:numel(stitched_files)
    im=imread(fullfile(stitch_dir,stitched_files{nn}));
    wp=prctile(im(:),white_point);
    bp=prctile(im(:),black_point);
    im=max(im,bp);
    im=min(im,wp);
    im=imresize(uint8(double(im-bp)/double(wp-bp)*255), 0.2); % this can work for current images, but can still break for very large images.
    imwrite(im,fullfile(stitch_dir,stitched_files{nn}(1:end-4)+".jpg"), ...
        'quality',100);

end

cd(fullfile(maxproj_folder,'..'));

%% local func

function check_fiji_install()
try
    Miji(false)
    MIJ.exit
    fprintf('MIJ installed correctly.\n')
catch ME
    javaaddpath('C:\barseq_envs\FIJI_jar\mij.jar')
    try
        Miji(false)
        MIJ.exit
    catch ME2
        error('MIJ was not set up and not found in path. Were all env files set up properly?\n')
    end
    warning('MIJ was not set up. Successfully added MIJ to path.\n')
end
end

end